<p align="center">
<img src="https://raw.githubusercontent.com/simple-icons/simple-icons/9.21.0/icons/simpleicons.svg" alt="Simple Icons" width=70>
<h3 align="center">Simple Icons</h3>
<p align="center">
Over 2700 Free SVG icons for popular brands. See them all on one page at <a href="https://simpleicons.org">SimpleIcons.org</a>. Contributions, corrections & requests can be made on GitHub.</p>
</p>

<p align="center">
<a href="https://github.com/simple-icons/simple-icons/actions?query=workflow%3AVerify+branch%3Adevelop"><img src="https://img.shields.io/github/actions/workflow/status/simple-icons/simple-icons/verify.yml?branch=develop&logo=github&label=tests" alt="Build status"/></a>
<a href="https://www.npmjs.com/package/simple-icons"><img src="https://img.shields.io/npm/v/simple-icons.svg?logo=npm" alt="NPM version"/></a>
<a href="https://packagist.org/packages/simple-icons/simple-icons"><img src="https://img.shields.io/packagist/v/simple-icons/simple-icons?logo=packagist&logoColor=white" alt="Build status"/></a>
<br/>
<a href="https://simpleicons.org"><img src="https://img.shields.io/badge/dynamic/json?color=informational&label=icons&prefix=%20&logo=simpleicons&query=%24.icons.length&url=https%3A%2F%2Fraw.githubusercontent.com%2Fsimple-icons%2Fsimple-icons%2Fdevelop%2F_data%2Fsimple-icons.json" alt="Number of icons currently in the library"/></a>
<a href="https://discord.gg/vUXFa7t5xJ"><img src="https://img.shields.io/discord/1142044630909726760?logo=discord&logoColor=white&label=discord" alt="Number of users active in our Discord server" /></a>
<a href="https://opencollective.com/simple-icons"><img src="https://img.shields.io/opencollective/all/simple-icons?logo=opencollective" alt="Backers and sponsors on Open Collective"/></a>
</p>

## Usage

> **Note**\
> We ask that all users read our [legal disclaimer](https://github.com/simple-icons/simple-icons/blob/develop/DISCLAIMER.md) before using icons from Simple Icons.

### General Usage

Icons can be downloaded as SVGs directly from [our website](https://simpleicons.org/) - simply click the download button of the icon you want, and the download will start automatically.

### CDN Usage

Icons can be served from a CDN such as [jsDelivr](https://www.jsdelivr.com/package/npm/simple-icons) or [Unpkg](https://unpkg.com/browse/simple-icons/). Simply use the `simple-icons` npm package and specify a version in the URL like the following:

```html
<img height="32" width="32" src="https://cdn.jsdelivr.net/npm/simple-icons@v9/icons/[ICON SLUG].svg" />
<img height="32" width="32" src="https://unpkg.com/simple-icons@v9/icons/[ICON SLUG].svg" />
```

Where `[ICON SLUG]` is replaced by the [slug] of the icon you want to use, for example:

```html
<img height="32" width="32" src="https://cdn.jsdelivr.net/npm/simple-icons@v9/icons/simpleicons.svg" />
<img height="32" width="32" src="https://unpkg.com/simple-icons@v9/icons/simpleicons.svg" />
```

These examples use the latest major version. This means you won't receive any updates following the next major release. You can use `@latest` instead to receive updates indefinitely. However, this will result in a `404` error if the icon is removed.

#### CDN with colors

We also provide a CDN service which allows you to use colors.

```html
<img height="32" width="32" src="https://cdn.simpleicons.org/[ICON SLUG]" />
<img height="32" width="32" src="https://cdn.simpleicons.org/[ICON SLUG]/[COLOR]" />
<img height="32" width="32" src="https://cdn.simpleicons.org/[ICON SLUG]/[COLOR]/[DARK_MODE_COLOR]" />
```

Where `[COLOR]` is optional, and can be replaced by the [hex colors](https://developer.mozilla.org/en-US/docs/Web/CSS/hex-color) or [CSS keywords](https://www.w3.org/wiki/CSS/Properties/color/keywords) of the icon you want to you use. The color is defaulted to the HEX color of the icon shown in [simpleicons.org website](https://simpleicons.org). `[DARK_MODE_COLOR]` is used for dark mode. The [CSS prefers-color-scheme](https://developer.mozilla.org/en-US/docs/Web/CSS/@media/prefers-color-scheme) will be used when a value is specified. For example:

```html
<img height="32" width="32" src="https://cdn.simpleicons.org/simpleicons" />
<img height="32" width="32" src="https://cdn.simpleicons.org/simpleicons/gray" />
<img height="32" width="32" src="https://cdn.simpleicons.org/simpleicons/hotpink" />
<img height="32" width="32" src="https://cdn.simpleicons.org/simpleicons/0cf" />
<img height="32" width="32" src="https://cdn.simpleicons.org/simpleicons/0cf9" />
<img height="32" width="32" src="https://cdn.simpleicons.org/simpleicons/00ccff" />
<img height="32" width="32" src="https://cdn.simpleicons.org/simpleicons/00ccff99" />
<img height="32" width="32" src="https://cdn.simpleicons.org/simpleicons/orange/pink" />
<img height="32" width="32" src="https://cdn.simpleicons.org/simpleicons/_/eee" />
```

### Node Usage <img src="https://raw.githubusercontent.com/simple-icons/simple-icons/9.21.0/icons/nodedotjs.svg" alt="Node" align=left width=24>

The icons are also available through our npm package. To install, simply run:

```shell
npm install simple-icons
```

All icons are imported from a single file, where `[ICON SLUG]` is replaced by a capitalized [slug]. We highly recommend using a bundler that can tree shake such as [webpack](https://webpack.js.org/) to remove the unused icon code:
```javascript
// Import a specific icon by its slug as:
// import { si[ICON SLUG] } from 'simple-icons'

// For example:
// use import/esm to allow tree shaking
import { siSimpleicons } from 'simple-icons';
// or with require/cjs
const { siSimpleicons } = require('simple-icons');
```

It will return an icon object:

```javascript
console.log(siSimpleicons);

/*
{
    title: 'Simple Icons',
    slug: 'simpleicons',
    hex: '111111',
    source: 'https://simpleicons.org/',
    svg: '<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">...</svg>',
    path: 'M12 12v-1.5c-2.484 ...',
    guidelines: 'https://simpleicons.org/styleguide',
    license: {
        type: '...',
        url: 'https://example.com/'
    }
}

NOTE: the `guidelines` entry will be `undefined` if we do not yet have guidelines for the icon.
NOTE: the `license` entry will be `undefined` if we do not yet have license data for the icon.
*/
```

If you need to iterate over all icons, use:

```javascript
import * as icons from 'simple-icons';
```

#### TypeScript Usage <img src="https://raw.githubusercontent.com/simple-icons/simple-icons/9.21.0/icons/typescript.svg" alt="Typescript" align=left width=19 height=19>

Type definitions are bundled with the package.

```typescript
import type { SimpleIcon } from 'simple-icons';
```

### PHP Usage <img src="https://raw.githubusercontent.com/simple-icons/simple-icons/9.21.0/icons/php.svg" alt="Php" align=left width=24 height=24>

The icons are also available through our Packagist package. To install, simply run:

```shell
composer require simple-icons/simple-icons
```

The package can then be used as follows, where `[ICON SLUG]` is replaced by a [slug]:

```php
<?php
// Import a specific icon by its slug as:
echo file_get_contents('path/to/package/icons/[ICON SLUG].svg');

// For example:
echo file_get_contents('path/to/package/icons/simpleicons.svg');

// <svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">...</svg>
?>
```

## Third-Party Extensions

| Extension | Author |
| :-- | :-- |
| [Angular module](https://github.com/avmaisak/ngx-simple-icons) <img src="https://raw.githubusercontent.com/simple-icons/simple-icons/9.21.0/icons/angular.svg" alt="Angular" align=left width=24 height=24> | [@avmaisak](https://github.com/avmaisak) |
| [Blazor Nuget package](https://github.com/TimeWarpEngineering/timewarp-simple-icons)  <img src="https://raw.githubusercontent.com/simple-icons/simple-icons/9.21.0/icons/blazor.svg" alt="Blazor" align=left width=24 height=24> | [@TimeWarpEngineering](https://github.com/TimeWarpEngineering) |
| [Blender add-on](https://github.com/mondeja/simple-icons-blender) <img src="https://raw.githubusercontent.com/simple-icons/simple-icons/9.21.0/icons/blender.svg" alt="Blender" align=left width=24 height=24> | [@mondeja](https://github.com/mondeja) |
| [Drawio library](https://github.com/mondeja/simple-icons-drawio) <img src="https://raw.githubusercontent.com/simple-icons/simple-icons/9.21.0/icons/diagramsdotnet.svg" alt="Drawio" align=left width=24 height=24> | [@mondeja](https://github.com/mondeja) |
| [Drupal module](https://www.drupal.org/project/simple_icons) <img src="https://raw.githubusercontent.com/simple-icons/simple-icons/9.21.0/icons/drupal.svg" alt="Drupal" align=left width=24 height=24> | [Phil Wolstenholme](https://www.drupal.org/u/phil-wolstenholme) |
| [Figma plugin](https://www.figma.com/community/plugin/1149614463603005908/Simple-Icons) <img src="https://raw.githubusercontent.com/simple-icons/simple-icons/9.21.0/icons/figma.svg" alt="Figma" align=left width=24 height=24> | [@LitoMore](https://github.com/LitoMore) |
| [Flutter package](https://pub.dev/packages/simple_icons) <img src="https://raw.githubusercontent.com/simple-icons/simple-icons/9.21.0/icons/flutter.svg" alt="Flutter" align=left width=24 height=24> | [@jlnrrg](https://github.com/jlnrrg) |
| [Framer component](https://github.com/LitoMore/simple-icons-framer) <img src="https://raw.githubusercontent.com/simple-icons/simple-icons/9.21.0/icons/framer.svg" alt="Framer" align=left width=24 height=24> | [@LitoMore](https://github.com/LitoMore) |
| [Hexo plugin](https://github.com/nidbCN/hexo-simpleIcons) <img src="https://raw.githubusercontent.com/simple-icons/simple-icons/9.21.0/icons/hexo.svg" alt="Hexo" align=left width=24 height=24> | [@nidbCN](https://github.com/nidbCN/) |
| [Home Assistant plugin](https://github.com/vigonotion/hass-simpleicons) <img src="https://raw.githubusercontent.com/simple-icons/simple-icons/9.21.0/icons/homeassistant.svg" alt="Home Assistant" align=left width=24 height=24> | [@vigonotion](https://github.com/vigonotion/) |
| [Hugo module](https://github.com/foo-dogsquared/hugo-mod-simple-icons) <img src="https://raw.githubusercontent.com/simple-icons/simple-icons/9.21.0/icons/hugo.svg" alt="Hugo" align=left width=24 height=24> | [@foo-dogsquared](https://github.com/foo-dogsquared) |
| [Java library](https://github.com/silentsoft/simpleicons4j) <img src="https://raw.githubusercontent.com/simple-icons/simple-icons/9.21.0/icons/openjdk.svg" alt="OpenJDK" align=left width=24 height=24> | [@silentsoft](https://github.com/silentsoft) |
| [Jetpack Compose library](https://github.com/DevSrSouza/compose-icons) <img src="https://raw.githubusercontent.com/simple-icons/simple-icons/9.21.0/icons/jetpackcompose.svg" alt="Jetpack Compose" align=left width=24 height=24> | [@devsrsouza](https://github.com/devsrsouza/) |
| [Kirby plugin](https://github.com/runxel/kirby3-simpleicons) <img src="https://raw.githubusercontent.com/simple-icons/simple-icons/9.21.0/icons/kirby.svg" alt="Kirby" align=left width=24 height=24> | [@runxel](https://github.com/runxel) |
| [LaTeX package](https://github.com/ineshbose/simple-icons-latex) <img src="https://raw.githubusercontent.com/simple-icons/simple-icons/9.21.0/icons/latex.svg" alt="LaTeX" align=left width=24 height=24> | [@ineshbose](https://github.com/ineshbose) |
| [Laravel package](https://github.com/ublabs/blade-simple-icons) <img src="https://raw.githubusercontent.com/simple-icons/simple-icons/9.21.0/icons/laravel.svg" alt="Laravel" align=left width=24 height=24> | [@adrian-ub](https://github.com/adrian-ub) |
| [Leptos crate](https://github.com/Carlosted/leptos-icons) <img src="https://raw.githubusercontent.com/simple-icons/simple-icons/9.21.0/icons/leptos.svg" alt="Leptos" align=left width=24 height=24> | [@Carlosted](https://github.com/Carlosted) |
| [Python package](https://github.com/sachinraja/simple-icons-py) <img src="https://raw.githubusercontent.com/simple-icons/simple-icons/9.21.0/icons/python.svg" alt="Python" align=left width=24 height=24> | [@sachinraja](https://github.com/sachinraja) |
| [React package](https://github.com/icons-pack/react-simple-icons) <img src="https://raw.githubusercontent.com/simple-icons/simple-icons/9.21.0/icons/react.svg" alt="React" align=left width=24 height=24> | [@wootsbot](https://github.com/wootsbot) |
| [Ruby gem](https://rubygems.org/gems/simple-icons-rails) <img src="https://raw.githubusercontent.com/simple-icons/simple-icons/9.21.0/icons/rubygems.svg" alt="Ruby" align=left width=24 height=24> | [@thepew](https://github.com/the-pew-inc) |
| [Solid package](https://github.com/x64Bits/solid-icons) <img src="https://raw.githubusercontent.com/simple-icons/simple-icons/9.21.0/icons/solid.svg" alt="Solid" align=left width=24 height=24> | [@x64Bits](https://github.com/x64Bits) |
| [Stream Deck icon pack](https://github.com/mackenly/simple-icons-stream-deck) <img src="https://raw.githubusercontent.com/simple-icons/simple-icons/9.21.0/icons/elgato.svg" alt="Stream Deck" align=left width=24 height=24> | [@mackenly](https://github.com/mackenly) |
| [Svelte package](https://github.com/icons-pack/svelte-simple-icons) <img src="https://raw.githubusercontent.com/simple-icons/simple-icons/9.21.0/icons/svelte.svg" alt="Svelte" align=left width=24 height=24> | [@wootsbot](https://github.com/wootsbot) |
| [Vue 3 package](https://github.com/wyatt-herkamp/vue3-simple-icons) <img src="https://raw.githubusercontent.com/simple-icons/simple-icons/9.21.0/icons/vuedotjs.svg" alt="Vue" align=left width=24 height=24> | [@wyatt-herkamp](https://github.com/wyatt-herkamp) |
| [Vue package](https://github.com/mainvest/vue-simple-icons) <img src="https://raw.githubusercontent.com/simple-icons/simple-icons/9.21.0/icons/vuedotjs.svg" alt="Vue" align=left width=24 height=24> | [@noahlitvin](https://github.com/noahlitvin) |
| [WordPress plugin](https://wordpress.org/plugins/simple-icons/) <img src="https://raw.githubusercontent.com/simple-icons/simple-icons/9.21.0/icons/wordpress.svg" alt="Wordpress" align=left width=24 height=24> | [@tjtaylo](https://github.com/tjtaylo) |

## Contribute

[![Good first issues open](https://img.shields.io/github/issues/simple-icons/simple-icons/good%20first%20issue?label=good%20first%20issues&logo=git&logoColor=white)](https://github.com/simple-icons/simple-icons/labels/good%20first%20issue)

Information describing how to contribute can be found in the file [CONTRIBUTING.md](https://github.com/simple-icons/simple-icons/blob/develop/CONTRIBUTING.md)

[slug]: https://github.com/simple-icons/simple-icons/blob/master/slugs.md
